<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * ContributionZUS
 *
 * @ORM\Table(name="contribution_zus")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\ContributionZUSRepository")
 *
 * @ExclusionPolicy("all")
 */
class ContributionZUS
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="monthFrom", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $monthFrom;

    /**
     * @var integer
     *
     * @ORM\Column(name="yearFrom", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $yearFrom;

    /**
     * @var integer
     *
     * @ORM\Column(name="monthTo", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $monthTo;

    /**
     * @var integer
     *
     * @ORM\Column(name="yearTo", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $yearTo;

    /**
     * @var float
     *
     * @ORM\Column(name="employeeE", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $employeeE;

    /**
     * @var float
     *
     * @ORM\Column(name="employeeR", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $employeeR;

    /**
     * @var float
     *
     * @ORM\Column(name="employeeCh", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $employeeCh;

    /**
     * @var float
     *
     * @ORM\Column(name="employeeW", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $employeeW;

    /**
     * @var float
     *
     * @ORM\Column(name="employeeZ", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $employeeZ;

    /**
     * @var float
     *
     * @ORM\Column(name="employerE", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $employerE;

    /**
     * @var float
     *
     * @ORM\Column(name="employerR", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $employerR;

    /**
     * @var string $description
     *
     * @ORM\Column(name="description", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $description;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set yearFrom
     *
     * @param integer $yearFrom
     * @return ContributionZUS
     */
    public function setYearFrom($yearFrom)
    {
        $this->yearFrom = $yearFrom;
    
        return $this;
    }

    /**
     * Get yearFrom
     *
     * @return integer 
     */
    public function getYearFrom()
    {
        return $this->yearFrom;
    }

    /**
     * Set monthFrom
     *
     * @param integer $monthFrom
     * @return ContributionZUS
     */
    public function setMonthFrom($monthFrom)
    {
        $this->monthFrom = $monthFrom;
    
        return $this;
    }

    /**
     * Get monthFrom
     *
     * @return integer 
     */
    public function getMonthFrom()
    {
        return $this->monthFrom;
    }

    /**
     * Set yearTo
     *
     * @param integer $yearTo
     * @return ContributionZUS
     */
    public function setYearTo($yearTo)
    {
        $this->yearTo = $yearTo;
    
        return $this;
    }

    /**
     * Get yearTo
     *
     * @return integer 
     */
    public function getYearTo()
    {
        return $this->yearTo;
    }

    /**
     * Set monthTo
     *
     * @param integer $monthTo
     * @return ContributionZUS
     */
    public function setMonthTo($monthTo)
    {
        $this->monthTo = $monthTo;
    
        return $this;
    }

    /**
     * Get monthTo
     *
     * @return integer 
     */
    public function getMonthTo()
    {
        return $this->monthTo;
    }

    /**
     * Set employeeE
     *
     * @param float $employeeE
     * @return ContributionZUS
     */
    public function setEmployeeE($employeeE)
    {
        $this->employeeE = $employeeE;
    
        return $this;
    }

    /**
     * Get employeeE
     *
     * @return float 
     */
    public function getEmployeeE()
    {
        return $this->employeeE;
    }

    /**
     * Set employeeR
     *
     * @param float $employeeR
     * @return ContributionZUS
     */
    public function setEmployeeR($employeeR)
    {
        $this->employeeR = $employeeR;
    
        return $this;
    }

    /**
     * Get employeeR
     *
     * @return float 
     */
    public function getEmployeeR()
    {
        return $this->employeeR;
    }

    /**
     * Set employeeCh
     *
     * @param float $employeeCh
     * @return ContributionZUS
     */
    public function setEmployeeCh($employeeCh)
    {
        $this->employeeCh = $employeeCh;
    
        return $this;
    }

    /**
     * Get employeeCh
     *
     * @return float 
     */
    public function getEmployeeCh()
    {
        return $this->employeeCh;
    }

    /**
     * Set employeeW
     *
     * @param float $employeeW
     * @return ContributionZUS
     */
    public function setEmployeeW($employeeW)
    {
        $this->employeeW = $employeeW;
    
        return $this;
    }

    /**
     * Get employeeW
     *
     * @return float 
     */
    public function getEmployeeW()
    {
        return $this->employeeW;
    }

    /**
     * Set employeeZ
     *
     * @param float $employeeZ
     * @return ContributionZUS
     */
    public function setEmployeeZ($employeeZ)
    {
        $this->employeeZ = $employeeZ;
    
        return $this;
    }

    /**
     * Get employeeZ
     *
     * @return float 
     */
    public function getEmployeeZ()
    {
        return $this->employeeZ;
    }

    /**
     * Set employerE
     *
     * @param float $employerE
     * @return ContributionZUS
     */
    public function setEmployerE($employerE)
    {
        $this->employerE = $employerE;
    
        return $this;
    }

    /**
     * Get employerE
     *
     * @return float 
     */
    public function getEmployerE()
    {
        return $this->employerE;
    }

    /**
     * Set employerR
     *
     * @param float $employerR
     * @return ContributionZUS
     */
    public function setEmployerR($employerR)
    {
        $this->employerR = $employerR;
    
        return $this;
    }

    /**
     * Get employerR
     *
     * @return float 
     */
    public function getEmployerR()
    {
        return $this->employerR;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return ContributionZUS
     */
    public function setDescription($description)
    {
        $this->description = $description;
    
        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }
}